<?php
/**
 *	-- Unanswered Posts --
 *	
 * This program is free software: you can redistribute it and/or 
 * modify it under the terms of the GNU General Public License as 
 * published by the Free Software Foundation, either version 3 of 
 * the License, or (at your option) any later version.
 * This program is distributed in the hope that it will be useful, 
 * but WITHOUT ANY WARRANTY; without even the implied warranty 
 * of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  
 * See the GNU General Public License for more details.
 * http://www.gnu.org/licenses/
 *	
 * (c) Copyright 2009 Sayak Banerjee :: sayakb [at] ubuntu [dot] com
 */

// Disallow direct access to this file for security reasons
if(!defined("IN_MYBB"))	die("Direct initialization of this file is not allowed.<br /><br />Please make sure IN_MYBB is defined.");

$plugins->add_hook('search_do_search_start', 'uap');
$plugins->add_hook('search_start', 'uap');
$plugins->add_hook('global_start', 'uap_run');


function uap_info()
{
   return array(
        'name'        => 'هاك مواضيع بدون ردود',
        'description' => 'يقوم باضافة رابط بقائمة الروابط السريعه يمكنك من معرفه المواضيع بدون ردود',
        'website'     => 'http://mods.mybboard.net/',
        'version'     => '1.0',
        'author'      => 'Sayak Banerjee',
        'authorsite'  => 'http://www.sayakbanerjee.com/',
        'guid'        => '67461ae22f028e97d019c268c8b12368'
        
    );
}

function uap_activate()
{
	global $lang, $mybb, $db;
	require MYBB_ROOT."/inc/adminfunctions_templates.php";
	find_replace_templatesets('header_welcomeblock_member', '#'.preg_quote('{$lang->welcome_todaysposts}').'#', '{$lang->welcome_todaysposts}{$uap}');
	$new_template = '</a> | <a href="{$mybb->settings[\'bburl\']}/search.php?action=getuap">{$lang->unanswered_posts}';
	$db->insert_query('templates', array(
		'title' => 'header_uap',
		'template' => $db->escape_string($new_template),
		'sid' => -1,
		'version' => 120
	));
	$settings_gid = $db->insert_query('settinggroups', array(
		'name' => 'uap',
		'title' => 'Unanswered topics',
		'description' => 'Search topics with no replies.',
		'disporder' => 50,
	));
	$db->insert_query('settings', array(
		'name' => 'uap_forum',
		'optionscode' => 'text',
		'value' => '',
		'title' => 'Exclude fid(s)',
		'description' => 'Fid(s) in CSV to exclude from search',
		'disporder' => 1,
		'gid' => $settings_gid
	));

}
function uap_deactivate()
{
	require MYBB_ROOT."/inc/adminfunctions_templates.php";
	find_replace_templatesets('header_welcomeblock_member', '#\{\$uap\}#', '', 0);

	global $db;
	$db->delete_query('templates', 'title = "header_welcomeblock_member_uap"');

}
function uap_run()
{
	global $lang, $templates, $db, $uap, $mybb;
	$lang->load("uap");
	eval('$uap = "'.$templates->get('header_uap').'";');

}
function uap()
{
        global $mybb, $db, $plugins, $lang, $fid;
	
	if($mybb->input['action'] == "getuap")
	{
		$where_sql = "t.replies = '0'";
	
		$unsearchforums = get_unsearchable_forums();
		if($unsearchforums)
		{
			$where_sql .= " AND t.fid NOT IN ($unsearchforums)";
		}
		$inactiveforums = get_inactive_forums();
		if($inactiveforums)
		{
			$where_sql .= " AND t.fid NOT IN ($inactiveforums)";
		}
		$dontshowforums = explode(",", $mybb->settings['uap_forum']);
		if(is_array($dontshowforums))
		{
			foreach($dontshowforums as $fid)
			{
				$fidarray[] = intval($fid);
			}
			
			$dontshowforums = implode(",", $fidarray);
		}
		if($dontshowforums)
		{
			$where_sql .= " AND t.fid NOT IN ($dontshowforums)";
		}
	
		$sid = md5(uniqid(microtime(), 1));
		$searcharray = array(
			"sid" => $db->escape_string($sid),
			"uid" => $mybb->user['uid'],
			"dateline" => TIME_NOW,
			"ipaddress" => $db->escape_string($session->ipaddress),
			"threads" => '',
			"posts" => '',
			"resulttype" => "threads",
			"querycache" => $db->escape_string($where_sql),
			"keywords" => ''
		);
	
		$plugins->run_hooks("search_do_search_process");
		$db->insert_query("searchlog", $searcharray);
		redirect("search.php?action=results&sid=".$sid, $lang->redirect_searchresults);
	}
}